# Weatherly PHP Backend (cPanel)

This backend is a plain PHP + MySQL implementation of the same `/api` contract used by the frontend (`services/weatherApi.ts`).

## Included

- Route-compatible API (`/auth`, `/user`, `/weather`, `/notams`, `/pireps`, `/airports`, `/flight-plans`, `/admin`, `/health`)
- JWT authentication (`Authorization: Bearer <token>`)
- MySQL schema and admin seed script
- cPanel-friendly front controller + `.htaccess`
- Platform management routes:
  - `/api/admin/platform/summary`
  - `/api/admin/platform/settings`
  - `/api/admin/airports`
- OpenAIP Core intelligence routes with cache-aware proxying:
  - `/api/openaip/airports/nearby`
  - `/api/openaip/airspaces/nearby`
  - `/api/openaip/obstacles/nearby`
  - `/api/openaip/smart-alerts`

## Production Targets

- Frontend: `https://weatherly.co.ke`
- API: `https://api.weatherly.co.ke`
- Windy embed: `https://windy.weatherly.co.ke`

## 1. Database Setup

Create MySQL resources in cPanel:

- Database: `weatherly_api`
- User: `weatherly_api`
- Password: `Weatherly2026@#`

Grant the user full privileges on the database, then import:

- `php-backend/database/schema.sql`
  - includes: `users`, `airports`, `pireps`, `flight_plans`, `api_keys`, `platform_settings`

## 2. Backend Files on cPanel

Recommended layout:

```text
public_html/
  weatherly-api/
    api/
      index.php
      .htaccess
    src/
    database/
    scripts/
    .env
```

Point subdomain `api.weatherly.co.ke` document root to:

- `public_html/weatherly-api/api`

## 3. Environment File

Copy:

- `php-backend/.env.example` -> `php-backend/.env`

Set/confirm:

- `DB_HOST`, `DB_PORT`, `DB_NAME`, `DB_USER`, `DB_PASS`
- `JWT_SECRET`
- `FRONTEND_ORIGINS` includes `https://weatherly.co.ke`
- Weather keys (`CHECKWX_API_KEY`, `OPENWEATHER_API_KEY`, `OPENAIP_API_KEY`, `WINDY_API_KEY`, etc.)

## 4. Seed Admin

Default seed credentials:

- Email: `admin@weatherly.co.ke`
- Password: `Weatherly2026@#`

Run in terminal (from `php-backend`):

```bash
php scripts/seed_admin.php
```

Optional overrides:

```bash
php scripts/seed_admin.php --email=admin@weatherly.co.ke --password=Weatherly2026@# --username="System Admin"
```

## 5. Frontend API Base URL

Set production frontend env:

- `VITE_API_BASE_URL=https://api.weatherly.co.ke/api`
