<?php
declare(strict_types=1);

require_once __DIR__ . '/../src/helpers.php';
require_once __DIR__ . '/../src/db.php';

$config = require __DIR__ . '/../src/config.php';

$options = getopt('', ['email::', 'password::', 'username::']);
$email = trim((string) ($options['email'] ?? $config['seed']['admin_email']));
$password = (string) ($options['password'] ?? $config['seed']['admin_password']);
$username = trim((string) ($options['username'] ?? $config['seed']['admin_username']));

if ($email === '' || $password === '') {
    fwrite(STDERR, "Email and password are required.\n");
    exit(1);
}

try {
    $pdo = db($config['db']);
} catch (Throwable $exception) {
    fwrite(STDERR, $exception->getMessage() . PHP_EOL);
    exit(1);
}

$existingStmt = $pdo->prepare('SELECT id FROM users WHERE email = :email LIMIT 1');
$existingStmt->execute(['email' => $email]);
$existing = $existingStmt->fetch();

if ($existing) {
    fwrite(STDOUT, "Admin user already exists for {$email}.\n");
    exit(0);
}

$id = generateUuidV4();
$hash = password_hash($password, PASSWORD_BCRYPT);
$preferences = json_encode(defaultPreferences(), JSON_UNESCAPED_SLASHES);
$favorites = json_encode([], JSON_UNESCAPED_SLASHES);

$insertStmt = $pdo->prepare(
    'INSERT INTO users (id, email, username, password_hash, role, favorite_airports, preferences)
     VALUES (:id, :email, :username, :password_hash, :role, :favorite_airports, :preferences)'
);

$insertStmt->execute([
    'id' => $id,
    'email' => $email,
    'username' => $username !== '' ? $username : explode('@', $email)[0],
    'password_hash' => $hash,
    'role' => 'admin',
    'favorite_airports' => $favorites,
    'preferences' => $preferences,
]);

fwrite(STDOUT, "Admin user created successfully.\n");
fwrite(STDOUT, "Email: {$email}\n");
fwrite(STDOUT, "Username: {$username}\n");
fwrite(STDOUT, "Role: admin\n");

