<?php
declare(strict_types=1);

function sendJson(array $payload, int $statusCode = 200): void
{
    if (!headers_sent()) {
        header('Content-Type: application/json; charset=utf-8');
    }

    http_response_code($statusCode);
    echo json_encode($payload, JSON_UNESCAPED_SLASHES);
}

function fail(string $error, int $statusCode = 400, array $extra = []): void
{
    sendJson(array_merge(['error' => $error], $extra), $statusCode);
}

